<?php get_header(); ?>
<main id="primary" class="site-main">
  <div class="container">

    <div class="res-area">
      <div class="left-area">
        <?php easy3x_show_ad('728x90'); ?>
        <?php get_template_part("template-parts/bc"); ?>

        <section class="section-latest-videos sections" aria-label="<?php the_archive_title(); ?>">


          <header class="category-header">
            <h1 class="category-title"><?= esc_html(single_term_title('', false)) ?></h1>
            <?php if (term_description()) : ?>
              <div class="category-description">
                <?= term_description(); ?>
              </div>
            <?php endif; ?>

            <!-- Bộ lọc -->
            <?php
            $filters = [
              'Latest'     => 'Latest',
              'Relate'    => 'Relate',
              'Most-View'   => 'Most View',
              'Recently-Updated' => 'Recently Updated',
              'Longest' => 'Longest'
            ];
            $current_filter = isset($_GET['sort']) ? sanitize_text_field($_GET['sort']) : 'Latest';
            ?>

            <nav class="category-nav" aria-label="Category navigation">
              <ul class="category-list">
                <?php foreach ($filters as $key => $label) : ?>
                  <li class="category-item">
                    <a
                      class="category-link<?= $current_filter === $key ? ' active' : '' ?>"
                      href="<?= esc_url(add_query_arg('sort', $key)) ?>">
                      <?= esc_html($label) ?>
                    </a>
                  </li>
                <?php endforeach; ?>
              </ul>
            </nav>
          </header>

          <!-- Danh sách bài viết -->
          <ul class="video-list">
            <?php
            global $wp_query;

            $orderby   = 'date';
            $meta_key  = '';
            $order     = 'DESC';

            switch ($current_filter) {
              case 'nhieu-view':
                $orderby = 'meta_value_num';
                $meta_key = 'video_view';
                break;
              case 'moi-cap-nhat':
                $orderby = 'modified';
                break;
              case 'video-dai-nhat':
                $orderby = 'meta_value_num';
                $meta_key = 'video_duration';
                break;
            }

            // Clone query hiện tại và chỉ sửa order/filter
            $args = array_merge($wp_query->query_vars, [
              'orderby' => $orderby,
              'order'   => $order,
              'meta_key' => $meta_key,
            ]);

            $query = new WP_Query($args);

            if ($query->have_posts()) :
              while ($query->have_posts()) : $query->the_post();
                $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
                $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
            ?>
                <li class="video-item">
                  <article class="video-post">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="video-link">
                      <div class="video-thumb">
                        <?php echo function_exists('easy3x_lazy_thumb') ? easy3x_lazy_thumb(get_the_ID()) : get_the_post_thumbnail(get_the_ID(), 'thumb-16x9'); ?>
                        <?php if ($video_label) : ?><span class="video-label"><?= esc_html($video_label) ?></span><?php endif; ?>
                        <?php if ($video_duration) : ?><span class="video-duration"><?= esc_html($video_duration) ?></span><?php endif; ?>
                      </div>
                      <h3 class="video-title"><?php the_title(); ?></h3>
                    </a>
                  </article>
                </li>
            <?php
              endwhile;
            else :
              echo '<p>Không có video nào :(</p>';
            endif;
            wp_reset_postdata();
            ?>
          </ul>

          <?php
          $paged = max(1, get_query_var('paged') ?: get_query_var('page'));
          $total_pages = $query->max_num_pages;

          $pagination = paginate_links([
            'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
            'format'    => '?paged=%#%',
            'current'   => $paged,
            'total'     => $total_pages,
            'mid_size'  => 1,
            'end_size'  => 1,
            'prev_next' => false,
            'type'      => 'array'
          ]);

          if ($pagination) :
          ?>
            <nav class="pagination" aria-label="Pagination">
              <a class="prev<?= $paged <= 1 ? ' disabled' : ''; ?>"
                href="<?= $paged > 1 ? esc_url(get_pagenum_link($paged - 1)) : '#'; ?>"
                aria-label="Previous page"
                <?= $paged <= 1 ? 'aria-disabled="true"' : ''; ?>>
                Prev
              </a>
              <div class="page-wrapper">
                <ul>
                  <?php foreach ($pagination as $page) : ?>
                    <li<?= strpos($page, 'current') !== false ? ' class="active" aria-current="page"' : ''; ?>>
                      <?= $page; ?>
                      </li>
                    <?php endforeach; ?>
                </ul>
              </div>
              <a class="next<?= $paged >= $total_pages ? ' disabled' : ''; ?>"
                href="<?= $paged < $total_pages ? esc_url(get_pagenum_link($paged + 1)) : '#'; ?>"
                aria-label="Next page"
                <?= $paged >= $total_pages ? 'aria-disabled="true"' : ''; ?>>
                Next
              </a>
            </nav>
          <?php endif; ?>

        </section>
        <?php easy3x_show_ad('728x90'); ?>

        <?php get_template_part("template-parts/latest"); ?>
      </div>
      <div class="right-area">
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/top"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/categories"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/tags"); ?>
      </div>
    </div>
  </div>
</main>
<?php get_footer(); ?>