document.addEventListener("DOMContentLoaded", () => {
  document.querySelectorAll(".video-action-bar").forEach(bar => {
    const postID = bar.dataset.postid;

    bar.querySelectorAll(".action-btn").forEach(btn => {
      const action = btn.dataset.action;
      const key = `video_action_${action}_${postID}`;
      const countEl = btn.querySelector(".count");

      // Khôi phục trạng thái từ localStorage
      if (localStorage.getItem(key)) {
        btn.classList.add("active");
      }

      btn.addEventListener("click", () => {
        if (localStorage.getItem(key)) {
          showAlert("Bạn đã thực hiện hành động này!");
          return;
        }

        // Optimistic update: tăng số hiện tại
        let currentCount = parseInt(countEl.textContent, 10) || 0;
        countEl.textContent = currentCount + 1;
        btn.classList.add("active");
        localStorage.setItem(key, "true");

        // Đồng thời gỡ nút đối nghịch ngay lập tức
        const oppositeAction = action === "like" ? "dislike" : "like";
        const oppKey = `video_action_${oppositeAction}_${postID}`;
        const oppBtn = bar.querySelector(`[data-action="${oppositeAction}"]`);
        if (oppBtn && oppBtn.classList.contains("active")) {
          oppBtn.classList.remove("active");
          localStorage.removeItem(oppKey);
          const oppCountEl = oppBtn.querySelector(".count");
          let oppCount = parseInt(oppCountEl.textContent, 10) || 0;
          oppCountEl.textContent = Math.max(oppCount - 1, 0); // giảm ngay
        }

        // Gửi request tới server
        fetch(videoActionAjax.url + `?t=${Date.now()}`, {
          method: "POST",
          headers: { "Content-Type": "application/x-www-form-urlencoded" },
          body: new URLSearchParams({
            action: "video_action_handler",
            post_id: postID,
            action_type: action,
          }),
          cache: "no-store"
        })
          .then(res => res.json())
          .then(data => {
            if (!data.success) throw new Error("Server rejected");

            // Đồng bộ lại số từ server (cả like và dislike nếu có)
            if (data.count !== undefined) {
              countEl.textContent = data.count;
            }
            if (data.opposite && data.opposite_count !== undefined) {
              const oppBtnServer = bar.querySelector(`[data-action="${data.opposite}"] .count`);
              if (oppBtnServer) oppBtnServer.textContent = data.opposite_count;
            }
          })
          .catch(() => {
            // Rollback nếu request lỗi
            countEl.textContent = currentCount;
            btn.classList.remove("active");
            localStorage.removeItem(key);
            showAlert("Lỗi kết nối, vui lòng thử lại!");
          });
      });
    });
  });
});
