document.addEventListener("DOMContentLoaded", () => {
  document.querySelectorAll(".action-btn").forEach((btn) => {
    const action = btn.dataset.action;
    const bar = btn.closest(".video-action-bar");
    const postID = bar.dataset.postid;
    const key = `video_action_${action}_${postID}`;

    // ✅ Gán .active nếu đã từng lưu localStorage
    if (localStorage.getItem(key)) {
      btn.classList.add("active");
    }

    // Sự kiện khi click
    btn.addEventListener("click", () => {
      if (localStorage.getItem(key)) {
        showAlert("Bạn đã thực hiện hành động này!");
        return;
      }

      fetch(videoActionAjax.url, {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: new URLSearchParams({
          action: "video_action_handler",
          post_id: postID,
          action_type: action,
        }),
      })
        .then((res) => res.json())
        .then((data) => {
          if (data.success) {
            localStorage.setItem(key, true);
            btn.classList.add("active");
            btn.querySelector(".count").textContent = data.count;

            // Xử lý gỡ nút đối nghịch
            if (data.opposite) {
              const oppKey = `video_action_${data.opposite}_${postID}`;
              localStorage.removeItem(oppKey);
              const oppBtn = bar.querySelector(
                `[data-action="${data.opposite}"]`
              );
              if (oppBtn) {
                oppBtn.classList.remove("active");
                let c = oppBtn.querySelector(".count");
                c.textContent = Math.max(parseInt(c.textContent) - 1, 0);
              }
            }
          }
        });
    });
  });
});
