<?php
// Phiên bản theme tự động từ style.css
$theme = wp_get_theme();
define('EASY3X_VERSION', $theme->get('Version'));

// Load Kirki nếu có
$kirki = get_template_directory() . '/inc/lib/kirki/kirki.php';
if (file_exists($kirki)) require_once $kirki;

// Load core
require_once get_template_directory() . '/inc/core.php';
require_once get_template_directory() . '/inc/rp.php';

// Tùy biến giao diện
add_action('after_setup_theme', function () {
  require_once get_template_directory() . '/inc/customizer.php';
});

// Thiết lập theme
add_action('after_setup_theme', function () {
  load_theme_textdomain('easy3x', get_template_directory() . '/languages');

  add_theme_support('title-tag');
  add_theme_support('custom-logo', [
    'height' => 100,
    'width' => 400,
    'flex-height' => true,
    'flex-width' => true
  ]);
  add_theme_support('post-thumbnails');
  add_theme_support('html5', [
    'search-form',
    'comment-form',
    'comment-list',
    'gallery',
    'caption'
  ]);
  add_theme_support('align-wide');
  add_theme_support('wp-block-styles');
  add_theme_support('responsive-embeds');
  add_theme_support('lazy-load-images');

  // Kích thước ảnh chuẩn video (16:9)
  add_image_size('thumb-16x9', 320, 180, true);
  add_image_size('thumb-16x9-md', 640, 360, true);
  add_image_size('thumb-16x9-lg', 1280, 720, true);

  register_nav_menus([
    'primary'   => __('Primary Menu', 'easy3x'),
    'footer_1'  => __('Footer Menu 1', 'easy3x'),
    'footer_2'  => __('Footer Menu 2', 'easy3x'),
    'footer_3'  => __('Footer Menu 3', 'easy3x'),
    'footer_4'  => __('Footer Menu 4', 'easy3x'),
  ]);
});

// Nạp CSS & JS
add_action('wp_enqueue_scripts', function () {
  $uri = get_template_directory_uri();

  wp_enqueue_style('easy3x-style', $uri . '/assets/css/style.css', [], EASY3X_VERSION);

  wp_enqueue_script('easy3x-main', $uri . '/assets/js/main.js', ['jquery'], EASY3X_VERSION, true);

  wp_enqueue_script('easy3x-jwplayer', $uri . '/inc/lib/jwplayer/jwplayer.js', [], EASY3X_VERSION, true);

  wp_enqueue_script('easy3x-ajax', $uri . '/assets/js/ajax.js', ['jquery'], EASY3X_VERSION, true);

  wp_localize_script('easy3x-ajax', 'videoActionAjax', [
    'url' => admin_url('admin-ajax.php')
  ]);

  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
});


// CSS meta box admin
add_action('admin_enqueue_scripts', function ($hook) {
  if (in_array($hook, ['post.php', 'post-new.php'])) {
    wp_enqueue_style('easy3x-meta', get_template_directory_uri() . '/assets/css/meta.css', [], null);
  }
});

// Dọn dẹp header WP
add_filter('the_generator', '__return_empty_string');
add_action('init', function () {
  remove_action('wp_head', 'wp_generator');
  remove_action('wp_head', 'rsd_link');
  remove_action('wp_head', 'wlwmanifest_link');
  remove_action('wp_head', 'wp_shortlink_wp_head');
  remove_action('wp_head', 'print_emoji_detection_script', 7);
  remove_action('wp_print_styles', 'print_emoji_styles');
});


add_action('wp_ajax_video_action_handler', 'handle_video_action');
add_action('wp_ajax_nopriv_video_action_handler', 'handle_video_action');

function handle_video_action()
{
  $post_id = intval($_POST['post_id']);
  $action = sanitize_text_field($_POST['action_type']);

  if (!in_array($action, ['like', 'dislike', 'heart'])) wp_send_json_error();

  $meta_key = 'video_' . $action;
  $opposite = $action === 'like' ? 'dislike' : ($action === 'dislike' ? 'like' : null);

  $count = (int) get_post_meta($post_id, $meta_key, true);
  $count++;
  update_post_meta($post_id, $meta_key, $count);

  // Nếu like/dislike thì trừ bên ngược lại nếu đã bấm
  if ($opposite) {
    $opposite_key = 'video_' . $opposite;
    $opp_count = (int) get_post_meta($post_id, $opposite_key, true);
    if ($opp_count > 0) update_post_meta($post_id, $opposite_key, $opp_count - 1);
  }

  wp_send_json_success([
    'count' => $count,
    'action' => $action,
    'opposite' => $opposite
  ]);
}


add_action('wp_enqueue_scripts', function () {
  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply'); // bắt buộc cho reply phân cấp
  }
});
