<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <?php if (is_single() || is_page()) : ?>
    <meta name="description" content="<?php echo esc_attr(wp_trim_words(get_the_excerpt(), 25)); ?>">
  <?php endif; ?>

  <?php wp_head(); ?>
  <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-BPYYS6ER3F"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-BPYYS6ER3F');
</script>
<meta name="juicyads-site-verification" content="2d45980ac957d29b96b05b6d12ff91ee">
</head>

<body <?php body_class(); ?>">
  <?php wp_body_open(); ?>

  <?php get_template_part("template-parts/header"); ?>
