<?php
defined('ABSPATH') || exit;

if (!class_exists('Kirki')) return;

Kirki::add_config('easy3x_config', [
  'option_type' => 'theme_mod',
  'capability'  => 'edit_theme_options',
]);

Kirki::add_panel('easy3x_panel', [
  'priority'    => 10,
  'title'       => esc_html__('Cài đặt giao diện', 'easy3x'),
  'description' => esc_html__('Tùy chỉnh Header, Footer, Trang chủ.', 'easy3x'),
]);

// Section: Cài đặt giao diện chung
Kirki::add_section('easy3x_general_settings', [
  'title'    => esc_html__('Cài đặt chung', 'easy3x'),
  'priority' => 1,
  'panel'    => 'easy3x_panel',
]);

// Màu sắc chính
Kirki::add_field('easy3x_config', [
  'type'      => 'color',
  'settings'  => 'color_primary',
  'label'     => esc_html__('Màu chính (Primary)', 'easy3x'),
  'section'   => 'easy3x_general_settings',
  'default'   => '#e63946',
  'transport' => 'auto',
  'output'    => [
    ['element' => ':root', 'property' => '--color-primary'],
  ],
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'color',
  'settings' => 'color_accent',
  'label'    => esc_html__('Màu nhấn (Accent)', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '#f72585',
  'output'   => [
    ['element' => ':root', 'property' => '--color-accent'],
  ],
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'color',
  'settings' => 'color_highlight',
  'label'    => esc_html__('Màu nổi bật', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '#ffd6e0',
  'output'   => [
    ['element' => ':root', 'property' => '--color-highlight'],
  ],
]);

// Màu nền và text phụ
Kirki::add_field('easy3x_config', [
  'type'     => 'color',
  'settings' => 'color_dark',
  'label'    => esc_html__('Màu nền chính (Dark)', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '#0a0a0a',
  'output'   => [
    ['element' => ':root', 'property' => '--color-dark'],
  ],
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'color',
  'settings' => 'color_text',
  'label'    => esc_html__('Màu chữ chính', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '#cccccc',
  'output'   => [
    ['element' => ':root', 'property' => '--color-text'],
  ],
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'color',
  'settings' => 'color_muted',
  'label'    => esc_html__('Màu chữ phụ', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '#888888',
  'output'   => [
    ['element' => ':root', 'property' => '--color-muted'],
  ],
]);

// Font size global
Kirki::add_field('easy3x_config', [
  'type'     => 'slider',
  'settings' => 'font_size_base',
  'label'    => esc_html__('Font size cơ bản (rem)', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => 1,
  'choices'  => [
    'min'  => 0.8,
    'max'  => 1.5,
    'step' => 0.05,
  ],
  'output'   => [
    ['element' => ':root', 'property' => '--font-size-base', 'value_pattern' => '$rem'],
  ],
]);

// Font weight mặc định
Kirki::add_field('easy3x_config', [
  'type'     => 'select',
  'settings' => 'font_weight_base',
  'label'    => esc_html__('Font weight cơ bản', 'easy3x'),
  'section'  => 'easy3x_general_settings',
  'default'  => '400',
  'choices'  => [
    '300' => 'Light (300)',
    '400' => 'Regular (400)',
    '500' => 'Medium (500)',
    '600' => 'Semi Bold (600)',
    '700' => 'Bold (700)',
  ],
  'output' => [
    ['element' => ':root', 'property' => '--font-weight-base'],
  ],
]);


Kirki::add_section('easy3x_header', [
  'title'    => esc_html__('Header', 'easy3x'),
  'panel'    => 'easy3x_panel',
  'priority' => 10,
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'image',
  'settings' => 'header_logo',
  'label'    => esc_html__('Logo Header', 'easy3x'),
  'section'  => 'easy3x_header',
  'priority' => 10,
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'code',
  'settings' => 'custom_head_code',
  'label'    => esc_html__('Mã chèn trong <head>', 'easy3x'),
  'section'  => 'easy3x_header',
  'priority' => 20,
  'choices'  => ['language' => 'html', 'theme' => 'monokai'],
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'code',
  'settings' => 'custom_footer_code',
  'label'    => esc_html__('Mã trước </body>', 'easy3x'),
  'section'  => 'easy3x_header',
  'priority' => 30,
  'choices'  => [
    'language' => 'html',
    'theme'    => 'monokai',
  ],
]);

Kirki::add_section('easy3x_home_sections', [
  'title'    => esc_html__('Danh sách Section Video', 'easy3x'),
  'panel'    => 'easy3x_panel',
  'priority' => 11,
]);

$tax_choices = [];
foreach (get_taxonomies(['public' => true], 'objects') as $taxonomy) {
  $terms = get_terms(['taxonomy' => $taxonomy->name, 'hide_empty' => false]);
  foreach ($terms as $term) {
    $tax_choices[$taxonomy->name . ':' . $term->term_id] = $taxonomy->labels->singular_name . ': ' . $term->name;
  }
}

Kirki::add_field('easy3x_config', [
  'type'        => 'repeater',
  'label'       => esc_html__('Các block Video trên Trang Chủ', 'easy3x'),
  'section'     => 'easy3x_home_sections',
  'priority'    => 10,
  'row_label'   => ['type' => 'field', 'value' => esc_html__('Block', 'easy3x'), 'field' => 'title'],
  'button_label' => esc_html__('Thêm Block', 'easy3x'),
  'settings'    => 'home_video_blocks',
  'default'     => [],
  'fields'      => [
    'title' => [
      'type'    => 'text',
      'label'   => esc_html__('Tiêu đề Section', 'easy3x'),
      'default' => 'Video Mới Cập Nhật',
    ],
    'icon' => [
      'type'    => 'text',
      'label'   => esc_html__('Mã SVG Icon (tuỳ chọn)', 'easy3x'),
      'default' => '',
    ],
    'taxonomy_term' => [
      'type'     => 'select',
      'label'    => esc_html__('Lọc theo chuyên mục/thẻ', 'easy3x'),
      'default'  => '',
      'choices'  => $tax_choices,
    ],
    'post_count' => [
      'type'    => 'number',
      'label'   => esc_html__('Số lượng bài viết', 'easy3x'),
      'default' => 10,
      'choices' => ['min' => 1, 'max' => 50],
    ],
    'orderby' => [
      'type'    => 'select',
      'label'   => esc_html__('Sắp xếp theo', 'easy3x'),
      'default' => 'modified',
      'choices' => [
        'date'     => esc_html__('Ngày đăng', 'easy3x'),
        'modified' => esc_html__('Ngày cập nhật', 'easy3x'),
        'title'    => esc_html__('Tiêu đề', 'easy3x'),
        'rand'     => esc_html__('Ngẫu nhiên', 'easy3x'),
      ],
    ],
    'order' => [
      'type'    => 'select',
      'label'   => esc_html__('Thứ tự hiển thị', 'easy3x'),
      'default' => 'DESC',
      'choices' => ['ASC' => 'Tăng dần', 'DESC' => 'Giảm dần'],
    ],
    'show_tags_slider' => [
      'type'     => 'checkbox',
      'label'    => esc_html__('Hiện slider thẻ / chuyên mục', 'easy3x'),
      'default'  => true,
      'choices'  => [
        'on'  => esc_html__('Bật', 'easy3x'),
        'off' => esc_html__('Tắt', 'easy3x'),
      ],
    ],

  ],
]);

Kirki::add_section('seo_text_section', [
  'title'    => esc_html__('SEO Expand Content', 'easy3x'),
  'panel'    => 'easy3x_panel',
  'priority' => 18,
]);

Kirki::add_field('easy3x_config', [
  'type'        => 'repeater',
  'label'       => esc_html__('Các block nội dung SEO mở rộng', 'easy3x'),
  'section'     => 'seo_text_section',
  'settings'    => 'seo_expand_blocks',
  'row_label'   => ['type' => 'field', 'value' => esc_html__('SEO Block', 'easy3x'), 'field' => 'title'],
  'button_label' => esc_html__('Thêm Block', 'easy3x'),
  'fields'      => [
    'title' => [
      'type'    => 'text',
      'label'   => esc_html__('Tiêu đề H2', 'easy3x'),
      'default' => 'Viet69 là gì? trang web tổng hợp clip 18+ hay nhất?',
    ],
    'content' => [
      'type'    => 'textarea',
      'label'   => esc_html__('Nội dung SEO (HTML/Text)', 'easy3x'),
      'default' => '<p>Hiện nay ngành công nghiệp phim người lớn đang phát triển nhanh chóng...</p>'
    ],
    'image' => [
      'type'  => 'image',
      'label' => esc_html__('Ảnh minh hoạ (tuỳ chọn)', 'easy3x'),
    ]
  ]
]);

Kirki::add_section('easy3x_footer', [
  'title'    => esc_html__('Footer', 'easy3x'),
  'panel'    => 'easy3x_panel',
  'priority' => 20,
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'image',
  'settings' => 'footer_logo',
  'label'    => esc_html__('Logo Footer', 'easy3x'),
  'section'  => 'easy3x_footer',
  'priority' => 10,
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'textarea',
  'settings' => 'footer_description',
  'label'    => esc_html__('Mô tả website', 'easy3x'),
  'section'  => 'easy3x_footer',
  'default'  => esc_html__('Xem phim miễn phí, chất lượng cao, không quảng cáo.', 'easy3x'),
  'priority' => 20,
]);

Kirki::add_field('easy3x_config', [
  'type'     => 'text',
  'settings' => 'footer_copyright',
  'label'    => esc_html__('Bản quyền chân trang', 'easy3x'),
  'section'  => 'easy3x_footer',
  'default'  => esc_html__('© 2025 Easy3x. All rights reserved.', 'easy3x'),
  'priority' => 30,
]);


Kirki::add_section('easy3x_ads', [
  'title'       => esc_html__('Quảng Cáo', 'easy3x'),
  'description' => esc_html__('Cài đặt mã quảng cáo cho website.', 'easy3x'),
  'panel'       => 'easy3x_panel',
  'priority'    => 160,
]);

// Danh sách Ads
$ads_sizes = [
  '728x90'  => 'Quảng cáo 728x90 (Leaderboard)',
  '320x100' => 'Quảng cáo 320x100 (Mobile Banner)',
  '300x250' => 'Quảng cáo 300x250 (Medium Rectangle)',
];

foreach ($ads_sizes as $size => $label) {

  // Toggle riêng cho từng ad
  Kirki::add_field('easy3x_config', [
    'type'     => 'toggle',
    'settings' => "easy3x_ad_enable_{$size}",
    'label'    => sprintf(esc_html__('Bật / Tắt %s', 'easy3x'), $label),
    'section'  => 'easy3x_ads',
    'default'  => false,
  ]);

  // Code Editor riêng cho từng ad
  Kirki::add_field('easy3x_config', [
    'type'            => 'code',
    'settings'        => "easy3x_ad_{$size}",
    'label'           => $label,
    'section'         => 'easy3x_ads',
    'default'         => '<div class="ad-' . $size . ' ads">Ads ' . $size . '</div>',
    'choices'         => [
      'language' => 'html',
      'theme'    => 'monokai',
    ],
    'active_callback' => [
      [
        'setting'  => "easy3x_ad_enable_{$size}",
        'operator' => '==',
        'value'    => true,
      ],
    ],
  ]);
}
