<?php get_header(); ?>
<main class="site-main">
  <div class="container">
    <div class="top-area">
      <?php get_template_part("template-parts/featured"); ?>
    </div>

    <div class="res-area">
      <div class="left-area">
        <?php easy3x_show_ad('728x90'); ?>
        <?php get_template_part("template-parts/main"); ?>
        <?php easy3x_show_ad('728x90'); ?>
        <?php get_template_part("template-parts/1"); ?>
      </div>
      <div class="right-area">
        <?php easy3x_show_ad('320x100'); ?>
        <?php get_template_part("template-parts/top"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/categories"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/tags"); ?>
        <?php
        $seo_blocks = get_theme_mod('seo_expand_blocks');

        if (!empty($seo_blocks)) :
          foreach ($seo_blocks as $block) :
            $title   = esc_html($block['title'] ?? '');
            $content = wp_kses_post($block['content'] ?? '');
            $img_url = esc_url($block['image'] ?? '');
        ?>
            <section class="seo-expand-block" aria-expanded="false">
              <button class="seo-toggle-btn" type="button" aria-label="Mở rộng nội dung SEO">
                <h2 class="seo-heading">
                  <?= $title ?>
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
                    <polyline points="6 9 12 15 18 9" />
                  </svg>
                </h2>
              </button>

              <div class="seo-content">
                <?php if ($img_url) : ?>
                  <img src="<?= $img_url ?>" alt="<?= $title ?>" loading="lazy" width="100%" />
                <?php endif; ?>
                <?= $content ?>
              </div>
            </section>
        <?php endforeach;
        endif; ?>
      </div>
    </div>

  </div>
</main>

<?php get_footer(); ?>