<?php
/* Template Name: Custom Search Page */

get_header();

$keyword = get_query_var('search_keyword') ?: sanitize_text_field($_GET['q'] ?? '');

?>

<header class="search-header">
  <div class="overlay"></div>
  <div class="search-container">
    <h1 class="search-title">
      <?php echo $keyword ? 'Results for: ' . esc_html($keyword) : 'Search results!'; ?>
    </h1>

    <!-- ✅ Search Form -->
    <form class="search-form" action="<?php echo home_url('/search/'); ?>" method="get" role="search">
      <label for="search-input" class="sr-only">Search</label>
      <input
        type="text"
        id="search-input"
        name="q"
        placeholder="Nhập một từ khóa..."
        value="<?php echo esc_attr($keyword); ?>"
        required>
      <button type="submit" class="search-btn">Find</button>
    </form>

    <!-- ✅ Popular searches -->
    <?php
    $popular_terms = get_terms([
      'taxonomy'   => 'search', // hoặc post_tag, category
      'orderby'    => 'count',
      'order'      => 'DESC',
      'number'     => 15,
      'hide_empty' => true,
    ]);
    if ($popular_terms && ! is_wp_error($popular_terms)) : ?>
      <nav class="popular-topics" aria-label="Chủ đề phổ biến">
        <ul>
          <?php foreach ($popular_terms as $term) : ?>
            <li>
              <a href="<?php echo esc_url(get_term_link($term)); ?>">
                <?php echo esc_html($term->name); ?>
              </a>
            </li>
          <?php endforeach; ?>
        </ul>
      </nav>
    <?php endif; ?>
  </div>
</header>

<main class="search-results">
  <ul class="video-list">
    <?php
    if ($keyword) {
      $paged = max(1, get_query_var('paged'));
      $args = [
        'post_type'      => 'post', // hoặc 'video'
        'posts_per_page' => 20,
        'paged'          => $paged,
        's'              => $keyword,
      ];
      $query = new WP_Query($args);

      if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post();
          $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
          $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
    ?>
          <li class="video-item">
            <article class="video-post">
              <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="video-link">
                <div class="video-thumb">
                  <?php echo easy3x_lazy_thumb(get_the_ID()); ?>
                  <?php if ($video_label) : ?>
                    <span class="video-label"><?php echo esc_html($video_label); ?></span>
                  <?php endif; ?>
                  <?php if ($video_duration) : ?>
                    <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                  <?php endif; ?>
                </div>
                <h3 class="video-title"><?php the_title(); ?></h3>
              </a>
            </article>
          </li>
    <?php
        endwhile;

        // ✅ Phân trang chuẩn WP
        the_posts_pagination([
          'mid_size'  => 2,
          'prev_text' => __('« Trước'),
          'next_text' => __('Tiếp »'),
        ]);

        wp_reset_postdata();
      else :
        echo '<p>No results found for this keyword.</p>';
      endif;
    }
    ?>
  </ul>
</main>

<?php get_footer(); ?>