<?php
get_header(); ?>

<main class="search-page site-main" role="main">
  <div class="container">
    <header class="search-header">
      <div class="overlay"></div>
      <div class="search-container">
        <h1 class="search-title">Search results!
        </h1>

        <!-- ✅ Search Form -->
        <form class="search-form" action="/search" method="get" role="search">
          <label for="search-input" class="sr-only">Search for a course or topic</label>
          <input
            type="text"
            id="search-input"
            name="q"
            placeholder="Nhập một từ khóa bất kì để tìm kiếm..."
            aria-label="Nhập một từ khóa bất kì để tìm kiếm..."
            required>
          <button type="submit" class="search-btn">Find</button>
        </form>

        <!-- ✅ Popular Searchs-->
        <?php
        // Hiển thị 15 taxonomy phổ biến nhất (ví dụ: category)
        $popular_terms = get_terms(array(
          'taxonomy'   => 'search', // hoặc thay bằng 'post_tag', hoặc taxonomy custom
          'orderby'    => 'count',
          'order'      => 'DESC',
          'number'     => 15,
          'hide_empty' => true,
        ));

        if (! empty($popular_terms) && ! is_wp_error($popular_terms)) : ?>
          <nav class="popular-topics" aria-label="Popular topics">
            <ul>
              <?php foreach ($popular_terms as $term) : ?>
                <li>
                  <a href="<?php echo esc_url(get_term_link($term)); ?>">
                    <?php echo esc_html($term->name); ?>
                  </a>
                </li>
              <?php endforeach; ?>
            </ul>
          </nav>
        <?php endif; ?>
      </div>
    </header>

    <?php get_template_part("template-parts/main"); ?>

  </div>
</main>

<?php get_footer(); ?>