<?php get_header(); ?>

<main id="primary" class="site-main">

  <div class="container">
    <section class="section-latest-videos" aria-label="Kết quả tìm kiếm">
      <h1 class="section-title">
        Results for: "<?php echo get_search_query(); ?>"
      </h1>

      <!-- Gợi ý chuyên mục + tag -->
      <section class="tag-slider-section" aria-label="Thẻ gợi ý">
        <h2 class="visually-hidden">Thẻ Gợi Ý</h2>
        <div class="tag-slider-wrapper">
          <button class="tag-nav prev" aria-label="Lùi">
            <svg width="24" height="24">
              <polyline points="15 18 9 12 15 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
          </button>
          <div class="tag-slider">
            <?php
            $categories = get_categories(['orderby' => 'count', 'order' => 'DESC', 'number' => 10]);
            foreach ($categories as $cat) {
              echo '<a class="tag-item" href="' . esc_url(get_category_link($cat)) . '">' . esc_html($cat->name) . '</a>';
            }
            $tags = get_tags(['orderby' => 'rand', 'number' => 20]);
            foreach ($tags as $tag) {
              echo '<a class="tag-item" href="' . esc_url(get_tag_link($tag)) . '">' . esc_html($tag->name) . '</a>';
            }
            ?>
          </div>
          <button class="tag-nav next" aria-label="Tiến">
            <svg width="24" height="24">
              <polyline points="9 18 15 12 9 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
          </button>
          <div class="tag-gradient left"></div>
          <div class="tag-gradient right"></div>
        </div>
      </section>

      <!-- Danh sách kết quả tìm kiếm -->
      <ul class="video-list">
        <?php if (have_posts()) : while (have_posts()) : the_post();
            $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
            $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
            $title_attr     = esc_attr(get_the_title());
            $permalink      = esc_url(get_permalink());
        ?>
            <li class="video-item">
              <article class="video-post">
                <a href="<?= $permalink ?>" title="<?= $title_attr ?>" class="video-link">
                  <div class="video-thumb">
                    <?= function_exists('easy3x_lazy_thumb') ? easy3x_lazy_thumb(get_the_ID()) : get_the_post_thumbnail(get_the_ID(), 'thumb-16x9'); ?>
                    <?php if ($video_label) : ?><span class="video-label"><?= esc_html($video_label) ?></span><?php endif; ?>
                    <?php if ($video_duration) : ?><span class="video-duration"><?= esc_html($video_duration) ?></span><?php endif; ?>
                  </div>
                  <h3 class="video-title"><?= get_the_title() ?></h3>
                </a>
              </article>
            </li>
          <?php endwhile;
        else : ?>
          <li class="video-item no-result">No results found.</li>
        <?php endif; ?>
      </ul>

      <?php
      $paged = max(1, get_query_var('paged') ?: get_query_var('page'));
      $total_pages = $query->max_num_pages;

      $pagination = paginate_links([
        'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
        'format'    => '?paged=%#%',
        'current'   => $paged,
        'total'     => $total_pages,
        'mid_size'  => 1,
        'end_size'  => 1,
        'prev_next' => false,
        'type'      => 'array'
      ]);

      if ($pagination) :
      ?>
        <nav class="pagination" aria-label="Pagination">
          <a class="prev<?= $paged <= 1 ? ' disabled' : ''; ?>"
            href="<?= $paged > 1 ? esc_url(get_pagenum_link($paged - 1)) : '#'; ?>"
            aria-label="Previous page"
            <?= $paged <= 1 ? 'aria-disabled="true"' : ''; ?>>
            Prev
          </a>
          <div class="page-wrapper">
            <ul>
              <?php foreach ($pagination as $page) : ?>
                <li<?= strpos($page, 'current') !== false ? ' class="active" aria-current="page"' : ''; ?>>
                  <?= $page; ?>
                  </li>
                <?php endforeach; ?>
            </ul>
          </div>
          <a class="next<?= $paged >= $total_pages ? ' disabled' : ''; ?>"
            href="<?= $paged < $total_pages ? esc_url(get_pagenum_link($paged + 1)) : '#'; ?>"
            aria-label="Next page"
            <?= $paged >= $total_pages ? 'aria-disabled="true"' : ''; ?>>
            Next
          </a>
        </nav>
      <?php endif; ?>
    </section>
  </div>

</main>
<?php get_footer(); ?>