<?php get_header(); ?>

<main id="primary" class="site-main">
  <div class="container">

    <div class="res-area">
      <div class="left-area">
        <?php easy3x_show_ad('728x90'); ?>
        <?php get_template_part("template-parts/bc"); ?>
        <div class="film-note" style="margin-bottom:15px;border: 3px solid #B8B612;padding: 5px;font-size: 12px;"> 👉  Please move to SERVER #2 if you cannot see SERVER #1</div>
        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

            <article id="post-<?php the_ID(); ?>" class="single-video">
              <?php get_template_part("template-parts/player"); ?>
              <?php easy3x_show_ad('728x90'); ?>

              <?php
              $content = get_the_content();

              if (trim(strip_tags($content))) : ?>
                <section class="video-description" aria-label="Mô tả video">
                  <div class="video-content">
                    <?= apply_filters('the_content', $content) ?>
                  </div>
                </section>
              <?php endif; ?>



              <div class="readmore-container">
                <div class="readmore-content" aria-expanded="false">

                  <?php
                  $categories = get_the_category();
                  if (!empty($categories)) :
                  ?>
                    <div class="video-cat">
                      <strong>Categories</strong>
                      <div class="video-cats">
                        <?php foreach ($categories as $cat) : ?>
                          <a href="<?= esc_url(get_category_link($cat->term_id)) ?>"
                            title="<?= esc_attr($cat->name) ?>">
                            <?= esc_html($cat->name) ?>
                          </a>
                        <?php endforeach; ?>
                      </div>
                    </div>
                  <?php endif; ?>

                  <?php
                  $tags = get_the_tags();
                  if (!empty($tags)) :
                  ?>
                    <div class="video-tag">
                      <strong>Tag</strong>
                      <div class="video-tags">
                        <?php foreach ($tags as $tag) : ?>
                          <a href="<?= esc_url(get_tag_link($tag->term_id)) ?>"
                            title="<?= esc_attr($tag->name) ?>">
                            <?= esc_html($tag->name) ?>
                          </a>
                        <?php endforeach; ?>
                      </div>
                    </div>
                  <?php endif; ?>

                  <?php if (has_post_thumbnail()) : ?>
                    <div class="video-thumbnail">
                      <?php the_post_thumbnail('thumb-16x9-md'); ?>
                    </div>
                  <?php endif; ?>

                </div>
                <button type="button" class="readmore-toggle" aria-label="Xem thêm">
                  More
                </button>
              </div>

            </article>

          <?php endwhile;
        else : ?>
          <section class="no-content"><?php get_template_part('template-parts/content', 'none'); ?></section>
        <?php endif; ?>

        <?php get_template_part("template-parts/related"); ?>

        <?php easy3x_show_ad('728x90'); ?>

        <?php
        // Nếu bài viết mở comment hoặc có comment thì mới load comments.php
        if (comments_open() || get_comments_number()) {
          comments_template();
        }
        ?>


      </div>
      <div class="right-area">
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/top"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/categories"); ?>
        <?php easy3x_show_ad('300x250'); ?>
        <?php get_template_part("template-parts/tags"); ?>
      </div>
    </div>

  </div>
</main>

<?php get_footer(); ?>