<?php
$sections = get_theme_mod('home_video_blocks', []);
if (empty($sections)) return;

foreach ($sections as $block) :

    $title       = esc_html($block['title'] ?? '');
    $icon        = $block['icon'] ?? '';
    $tax_val     = $block['taxonomy_term'] ?? '';
    $count       = absint($block['post_count'] ?? 10);
    $orderby     = $block['orderby'] ?? 'modified';
    $order       = $block['order'] ?? 'DESC';
    $show_slider = !empty($block['show_tags_slider']);

    // Parse taxonomy & term_id
    $taxonomy = '';
    $term_id  = 0;
    $term_url = '';
    if (strpos($tax_val, ':') !== false) {
        [$taxonomy, $term_id] = explode(':', $tax_val);
        $term_id  = absint($term_id);
        $term_url = $taxonomy && $term_id ? get_term_link($term_id, $taxonomy) : '';
    }

    // Query video
    $query_args = [
        'post_type'           => 'post', // hoặc 'video'
        'posts_per_page'      => $count,
        'orderby'             => $orderby,
        'order'               => $order,
        'ignore_sticky_posts' => true,
    ];
    if ($taxonomy && $term_id) {
        $query_args['tax_query'] = [[
            'taxonomy' => $taxonomy,
            'field'    => 'term_id',
            'terms'    => $term_id,
        ]];
    }
    $query = new WP_Query($query_args);
    ?>
    
    <section class="section-latest-videos sections" aria-label="<?php echo esc_attr($title); ?>">
        
        <header class="section-header">
            <h2 class="section-title">
                <?php if ($term_url): ?>
                    <a href="<?php echo esc_url($term_url); ?>" title="<?php echo esc_attr($title); ?>">
                        <?php echo $title; ?>
                    </a>
                <?php else: ?>
                    <?php echo $title; ?>
                <?php endif; ?>
                <?php if ($icon) : ?>
                    <span class="icon-wrap" aria-hidden="true"><?php echo $icon; ?></span>
                <?php endif; ?>
            </h2>

            <?php if ($term_url): ?>
                <a class="btn-more" href="<?php echo esc_url($term_url); ?>" aria-label="Xem thêm <?php echo esc_attr($title); ?>">
                    Xem thêm
                </a>
            <?php endif; ?>
        </header>

        <?php if ($show_slider) : ?>
            <section class="tag-slider-section" aria-label="Thẻ gợi ý">
                <h2 class="visually-hidden">Thẻ Gợi Ý</h2>
                <div class="tag-slider-wrapper">
                    <button class="tag-nav prev" aria-label="Lùi">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"><polyline points="15 18 9 12 15 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/></svg>
                    </button>
                    <div class="tag-slider">
                        <?php
                        $terms = $taxonomy === 'category'
                            ? get_categories(['orderby' => 'count', 'order' => 'DESC', 'number' => 10])
                            : get_tags(['orderby' => 'rand', 'number' => 20]);
                        foreach ($terms as $term) {
                            $link = $taxonomy === 'category'
                                ? get_category_link($term->term_id)
                                : get_tag_link($term->term_id);
                            echo '<a class="tag-item" href="' . esc_url($link) . '">' . esc_html($term->name) . '</a>';
                        }
                        ?>
                    </div>
                    <button class="tag-nav next" aria-label="Tiến">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"><polyline points="9 18 15 12 9 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round"/></svg>
                    </button>
                    <div class="tag-gradient left"></div>
                    <div class="tag-gradient right"></div>
                </div>
            </section>
        <?php endif; ?>

        <ul class="video-list">
            <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
                $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
                $permalink      = get_permalink();
                $title_attr     = esc_attr(get_the_title());
                ?>
                <li class="video-item">
                    <article class="video-post">
                        <a href="<?php echo esc_url($permalink); ?>" title="<?php echo $title_attr; ?>" class="video-link">
                            <div class="video-thumb">
                                <?php echo easy3x_lazy_thumb(get_the_ID()); ?>
                                <?php if ($video_label) : ?>
                                    <span class="video-label"><?php echo esc_html($video_label); ?></span>
                                <?php endif; ?>
                                <?php if ($video_duration) : ?>
                                    <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                                <?php endif; ?>
                            </div>
                            <h3 class="video-title"><?php the_title(); ?></h3>
                        </a>
                    </article>
                </li>
            <?php endwhile; wp_reset_postdata(); endif; ?>
        </ul>
    </section>
<?php endforeach; ?>
