<?php
// SVG icon phân cách
$divider = '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="bc-icon"><polyline points="9 18 15 12 9 6"></polyline></svg>';
?>

<nav class="breadcrumb" aria-label="Breadcrumb" itemscope itemtype="https://schema.org/BreadcrumbList">
  <?php
  $position = 1;
  // Home
  echo '<span itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
  echo '<a href="' . esc_url(home_url('/')) . '" itemprop="item" class="bc-home">';
  echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="bc-icon"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>';
  echo '<span itemprop="name">Home</span></a>';
  echo '<meta itemprop="position" content="' . $position++ . '" />';
  echo '</span>';

  echo $divider;

  // Breadcrumb logic
  if (is_single()) {
    $categories = get_the_category();
    if (!empty($categories)) {
      $cat = $categories[0];
      echo '<span itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
      echo '<a href="' . esc_url(get_category_link($cat->term_id)) . '" itemprop="item"><span itemprop="name">' . esc_html($cat->name) . '</span></a>';
      echo '<meta itemprop="position" content="' . $position++ . '" />';
      echo '</span>';
      echo $divider;
    }

    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">' . esc_html(get_the_title()) . '</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';

  } elseif (is_page()) {
    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">' . esc_html(get_the_title()) . '</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';

  } elseif (is_category() || is_tag() || is_tax()) {
    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">' . single_term_title('', false) . '</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';

  } elseif (is_search()) {
    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">Tìm kiếm: ' . get_search_query() . '</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';

  } elseif (is_404()) {
    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">Không tìm thấy trang</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';

  } elseif (is_archive()) {
    echo '<span class="breadcrumb-current" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">';
    echo '<span itemprop="name">' . post_type_archive_title('', false) . '</span>';
    echo '<meta itemprop="position" content="' . $position++ . '" />';
    echo '</span>';
  }
  ?>
</nav>
