<section class="featured-section">
  <div class="featured-header">
    <h2 class="section-title">Trending Videos<span class="icon-wrap" aria-hidden="true">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
          <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
        </svg>
      </span></h2>
    <div class="video-nav">
      <button class="nav-btn prev-btn" aria-label="Trước"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
          <polyline points="15 18 9 12 15 6"></polyline>
        </svg></button>
      <button class="nav-btn next-btn" aria-label="Tiếp"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
          <polyline points="9 18 15 12 9 6"></polyline>
        </svg></button>
    </div>
  </div>

  <div class="video-slider-wrapper">
    <ul class="video-list">
<?php
$args = [
  'post_type'           => 'post', // hoặc 'video' nếu CPT
  'posts_per_page'      => 20, // lấy nhiều hơn để lọc top 10
  'ignore_sticky_posts' => true,
  'no_found_rows'       => true,
  'meta_query'          => [
    'relation' => 'OR',
    ['key' => 'video_view',  'compare' => 'EXISTS'],
    ['key' => 'video_like',  'compare' => 'EXISTS'],
    ['key' => 'video_heart', 'compare' => 'EXISTS'],
  ]
];
$query = new WP_Query($args);

$ranked_posts = [];

if ($query->have_posts()) :
  while ($query->have_posts()) : $query->the_post();
    $views  = (int) get_post_meta(get_the_ID(), 'video_view', true);
    $likes  = (int) get_post_meta(get_the_ID(), 'video_like', true);
    $hearts = (int) get_post_meta(get_the_ID(), 'video_heart', true);

    $days_old   = max(1, floor((time() - get_post_time('U')) / DAY_IN_SECONDS));
    $time_bonus = max(0, 50 - $days_old);

    $score = ($views) + ($likes * 5) + ($hearts * 10) + $time_bonus;

    $ranked_posts[] = [
      'id'    => get_the_ID(),
      'score' => $score
    ];
  endwhile;
  wp_reset_postdata();
endif;

// Sắp xếp từ cao xuống thấp
usort($ranked_posts, fn($a, $b) => $b['score'] <=> $a['score']);

// Render top 10
foreach (array_slice($ranked_posts, 0, 10) as $post_data) :
  $post_id        = $post_data['id'];
  $video_label    = get_post_meta($post_id, 'video_label', true);
  $video_duration = get_post_meta($post_id, 'video_duration', true);
  $thumb_url      = get_the_post_thumbnail_url($post_id, 'thumb-3x4') ?: 'https://via.placeholder.com/240x320?text=No+Thumbnail';
  $title_attr     = esc_attr(get_the_title($post_id));
  $permalink      = esc_url(get_permalink($post_id));
?>
  <li class="video-item">
    <article class="video-post">
      <a href="<?php echo $permalink; ?>" title="<?php echo $title_attr; ?>" class="video-link hero">
        <div class="video-thumb">
          <?php echo easy3x_lazy_thumb($post_id); ?>
          <span class="hot-tag">Hot</span>
        </div>
        <h3 class="video-title"><?php echo get_the_title($post_id); ?></h3>
      </a>
    </article>
  </li>
<?php endforeach; ?>
</ul>
  </div>
</section>