<?php
$footer_logo = get_theme_mod('footer_logo');
$footer_desc = get_theme_mod('footer_description') ?: get_bloginfo('description');
$footer_copy = get_theme_mod('footer_copyright');
$locations = get_nav_menu_locations();
?>
<footer class="site-footer" role="contentinfo">
  <div class="container footer-container">
    <?php if ($footer_desc) : ?>
      <div class="footer-about">
        <h2 class="footer-title">About</h2>
        <p><?= esc_html($footer_desc) ?></p>
      </div>
    <?php endif; ?>

    <nav class="footer-menus" aria-label="Footer Navigation">
      <?php
      foreach (['footer_1', 'footer_2', 'footer_3', 'footer_4'] as $location_key) {
        if (!isset($locations[$location_key])) continue;

        $menu_obj = wp_get_nav_menu_object($locations[$location_key]);
        if (!$menu_obj) continue;

        $menu_title = esc_html($menu_obj->name);

        wp_nav_menu([
          'theme_location' => $location_key,
          'container'      => 'div',
          'container_class' => 'footer-menu',
          'items_wrap'     => '<h2 class="footer-title">' . $menu_title . '</h2><ul>%3$s</ul>',
          'fallback_cb'    => false,
          'depth'          => 1,
        ]);
      }

      ?>
    </nav>

  </div>

  <?php if ($footer_copy) : ?>
    <div class="footer-bottom">
      <small><?= esc_html($footer_copy) ?></small>
    </div>
  <?php endif; ?>

  <div id="action-alert">
    Bạn đã thực hiện hành động này!
  </div>

  <button class="btn scroll-to-top" aria-label="Lên đầu trang">
    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
      <polyline points="18 15 12 9 6 15"></polyline>
    </svg>
  </button>
  <script>
    function showAlert(msg) {
      const a = document.getElementById('action-alert');
      a.textContent = msg;
      a.classList.add('active');
      setTimeout(() => {
        a.classList.remove('active');
      }, 2000);
    }

    const toggles = document.querySelectorAll(".submenu-toggle");

    toggles.forEach((toggle) => {
      const parentItem = toggle.closest(".menu-item.has-children");
      const menu = parentItem.querySelector(".mega-menu");

      toggle.addEventListener("click", (e) => {
        e.preventDefault();

        // Đóng tất cả menu khác
        document
          .querySelectorAll(".menu-item.has-children .mega-menu.open")
          .forEach((openMenu) => {
            if (openMenu !== menu) openMenu.classList.remove("open");
          });

        // Toggle hiện tại
        menu.classList.toggle("open");
      });
    });
  </script>
</footer>