<?php
$is_home = is_front_page() || is_home();
$site_name = get_bloginfo('name');
$logo_url  = get_theme_mod('header_logo'); // hoặc thay bằng URL tĩnh
$tag = $is_home ? 'h1' : 'div';
?>

<header class="site-header">
  <div class="container in-header">
    <<?= $tag ?> class="header-logo">
      <a href="<?= esc_url(home_url('/')) ?>" title="Trang chủ - <?= esc_attr($site_name) ?>">
        <img
          src="<?= esc_url($logo_url ?: 'https://via.placeholder.com/160x40?text=Logo') ?>"
          alt="<?= esc_attr($site_name) ?>"
          width="160"
          height="40"
          loading="lazy"
          decoding="async" />
      </a>
    </<?= $tag ?>>
    <nav class="header-nav" aria-label="Main Navigation">
      <button
        class="close-btn btn"
        aria-label="Đóng menu">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
          viewBox="0 0 24 24" fill="none" stroke="currentColor"
          stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
          class="icon-svg" aria-hidden="true">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
        <span class="close-text">Close Menu</span>
      </button>

      <?php
      wp_nav_menu([
        'theme_location' => 'primary',
        'container'      => false,
        'menu_class'     => 'main-menu',
        'fallback_cb'    => false,
        'depth'          => 3,
        'walker'         => new class extends Walker_Nav_Menu {
          function start_lvl(&$output, $depth = 0, $args = null)
          {
            $indent = str_repeat("\t", $depth);
            $output .= "\n$indent<ul class=\"sub-menu mega-menu depth-$depth\" role=\"menu\">\n";
          }

          function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
          {
            $title     = esc_html($item->title);
            $url       = esc_url($item->url);
            $has_child = in_array('menu-item-has-children', $item->classes, true);

            $output .= '<li class="menu-item depth-' . $depth . ($has_child ? ' has-children' : '') . '">';

            // 👉 Gộp a + icon button vào 1 wrapper
            $output .= '<div class="menu-item-wrapper">';

            // Link
            $output .= '<a href="' . $url . '" class="menu-link" title="' . esc_attr($title) . '">' . $title . '</a>';

            // Icon toggle riêng
            if ($has_child) {
              $output .= '<button class="submenu-toggle" aria-expanded="false" aria-label="' . esc_attr__('Toggle submenu', 'easy3x') . '">';
              $output .= '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-dropdown" aria-hidden="true"><polyline points="6 9 12 15 18 9"></polyline></svg>';
              $output .= '</button>';
            }

            $output .= '</div>'; // end .menu-item-wrapper
          }

          function end_el(&$output, $item, $depth = 0, $args = null)
          {
            $output .= "</li>\n";
          }
        }
      ]);
      ?>


    </nav>


    <form
      class="header-form"
      action="<?php echo esc_url(home_url('/')); ?>"
      method="get"
      role="search"
      aria-label="Tìm Kiếm">
      <label for="search-input" class="visually-hidden">Tìm kiếm</label>
      <div class="in-search">
        <button type="submit" aria-label="Tìm Kiếm" class="btn">
          <svg class="icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="11" cy="11" r="8"></circle>
            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
          </svg>
        </button>
        <input
          type="search"
          id="search-input"
          class="search-field"
          name="s"
          placeholder="Find video, actor..."
          value="<?php the_search_query(); ?>"
          required
          aria-required="true"
          autocomplete="off" />
      </div>

      <button type="button" class="btn close-search" aria-label="Đóng tìm kiếm">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
          <line x1="18" y1="6" x2="6" y2="18"></line>
          <line x1="6" y1="6" x2="18" y2="18"></line>
        </svg>
      </button>
    </form>


    <button type="button" class="btn menu-btn" aria-label="Menu">
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
        role="img"
        aria-hidden="true"
        class="icon-svg">
        <line x1="3" y1="12" x2="21" y2="12"></line>
        <line x1="3" y1="6" x2="21" y2="6"></line>
        <line x1="3" y1="18" x2="21" y2="18"></line>
      </svg>
    </button>
    <button type="button" class="btn search-btn" aria-label="Tìm Kiếm">
      <svg
        xmlns="http://www.w3.org/2000/svg"
        width="24"
        height="24"
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        stroke-width="2"
        stroke-linecap="round"
        stroke-linejoin="round"
        role="img"
        aria-hidden="true"
        class="icon-svg">
        <circle cx="11" cy="11" r="8"></circle>
        <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
      </svg>
    </button>
  </div>
  <div class="overlay"></div>
</header>