<section class="section-latest-videos sections" aria-label="Video mới nhất">
  <h2 class="section-title">Latest Video</h2>

  <ul class="video-list">
    <?php
    $latest = new WP_Query([
      'post_type'           => 'post', // hoặc 'video' nếu có CPT riêng
      'posts_per_page'      => 12,
      'orderby'             => 'modified',
      'order'               => 'DESC',
      'ignore_sticky_posts' => true,
      'no_found_rows'       => true, // 🚀 tối ưu: bỏ tính toán phân trang
      'update_post_meta_cache' => false, // 🚀 giảm query thừa
      'update_post_term_cache' => false, // 🚀 giảm query thừa
    ]);

    if ($latest->have_posts()) :
      while ($latest->have_posts()) :
        $latest->the_post();

        $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
        $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
    ?>
        <li class="video-item">
          <article <?php post_class('video-post'); ?>>
            <a href="<?php the_permalink(); ?>" class="video-link">
              <div class="video-thumb">
                <?php echo easy3x_lazy_thumb(get_the_ID()); ?>
                <?php if ($video_label) : ?>
                  <span class="video-label"><?php echo esc_html($video_label); ?></span>
                <?php endif; ?>
                <?php if ($video_duration) : ?>
                  <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                <?php endif; ?>
              </div>
              <h3 class="video-title"><?php the_title(); ?></h3>
            </a>
          </article>
        </li>
    <?php
      endwhile;
      wp_reset_postdata();
    endif;
    ?>
  </ul>

</section>