<section class="section-latest-videos sections" aria-label="New Video Update">
  <h2 class="section-title">New Video Update<span class="icon-wrap" aria-hidden="true">
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
        <circle cx="12" cy="12" r="10"></circle>
        <line x1="2" y1="12" x2="22" y2="12"></line>
        <path d="M12 2a15.3 15.3 0 0 1 4 10 15.3 15.3 0 0 1-4 10 15.3 15.3 0 0 1-4-10 15.3 15.3 0 0 1 4-10z"></path>
      </svg>
    </span></h2>


  <section class="tag-slider-section" aria-label="Hint card">
    <h2 class="visually-hidden">Hint card</h2>

    <div class="tag-slider-wrapper">
      <button class="tag-nav prev" aria-label="Lùi">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24">
          <polyline points="15 18 9 12 15 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="icon-svg" />
        </svg>
      </button>

      <div class="tag-slider">
        <?php
        // Lấy 10 chuyên mục phổ biến nhất
        $categories = get_categories([
          'orderby' => 'count',
          'order'   => 'DESC',
          'number'  => 10,
        ]);

        foreach ($categories as $cat) {
          echo '<a class="tag-item" href="' . esc_url(get_category_link($cat->term_id)) . '">' . esc_html($cat->name) . '</a>';
        }

        // Lấy 20 tag ngẫu nhiên
        $tags = get_tags([
          'orderby' => 'rand',
          'number'  => 20,
        ]);

        foreach ($tags as $tag) {
          echo '<a class="tag-item" href="' . esc_url(get_tag_link($tag->term_id)) . '">' . esc_html($tag->name) . '</a>';
        }
        ?>
      </div>

      <button class="tag-nav next" aria-label="Tiến">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24">
          <polyline points="9 18 15 12 9 6" stroke="currentColor" stroke-width="2" fill="none" stroke-linecap="round" stroke-linejoin="round" class="icon-svg" />
        </svg>
      </button>

      <div class="tag-gradient left"></div>
      <div class="tag-gradient right"></div>
    </div>
  </section>


  <ul class="video-list">
    <?php
    $paged = max(1, get_query_var('paged') ?: get_query_var('page'));
    $latest = new WP_Query([
      'post_type'           => 'post', // hoặc 'video'
      'posts_per_page'      => 24,
      'orderby'             => 'modified',
      'order'               => 'DESC',
      'paged'               => $paged,
      'ignore_sticky_posts' => true,
    ]);

    if ($latest->have_posts()) :
      while ($latest->have_posts()) : $latest->the_post();
        $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
        $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
    ?>
        <li class="video-item">
          <article class="video-post">
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="video-link">
              <div class="video-thumb">
                <?php echo easy3x_lazy_thumb(get_the_ID()); ?>
                <?php if ($video_label) : ?>
                  <span class="video-label"><?php echo esc_html($video_label); ?></span>
                <?php endif; ?>
                <?php if ($video_duration) : ?>
                  <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                <?php endif; ?>
              </div>
              <h3 class="video-title"><?php the_title(); ?></h3>
            </a>
          </article>
        </li>
      <?php endwhile; ?>
    <?php wp_reset_postdata();
    endif; ?>
  </ul>

  <?php
  $total_pages = $latest->max_num_pages;
  $pagination = paginate_links([
    'base'      => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
    'format'    => '?paged=%#%',
    'current'   => $paged,
    'total'     => $total_pages,
    'mid_size'  => 1, // 3 ô cho trang hiện tại: current -1, current, current +1
    'end_size'  => 3, // hiển thị ô đầu và cuối
    'prev_next' => false, // tắt Prev/Next mặc định, tự tạo nút riêng
    'type'      => 'array'
  ]);

  if ($pagination) :
  ?>
    <nav class="pagination" aria-label="Pagination">
      <a class="prev<?php echo $paged <= 1 ? ' disabled' : ''; ?>"
        href="<?php echo $paged > 1 ? esc_url(get_pagenum_link($paged - 1)) : '#'; ?>"
        aria-label="Previous page"
        <?php if ($paged <= 1) echo 'aria-disabled="true"'; ?>>
        Prev
      </a>

      <div class="page-wrapper">
        <ul>
          <?php foreach ($pagination as $page) : ?>
            <li<?php echo strpos($page, 'current') !== false ? ' class="active" aria-current="page"' : ''; ?>>
              <?php echo $page; ?>
              </li>
            <?php endforeach; ?>
        </ul>
      </div>

      <a class="next<?php echo $paged >= $total_pages ? ' disabled' : ''; ?>"
        href="<?php echo $paged < $total_pages ? esc_url(get_pagenum_link($paged + 1)) : '#'; ?>"
        aria-label="Next page"
        <?php if ($paged >= $total_pages) echo 'aria-disabled="true"'; ?>>
        Next
      </a>
    </nav>
  <?php endif; ?>

</section>