<?php
$vast_url = get_template_directory_uri() . '/inc/lib/jwplayer/vast.xml';
?>

<section class="video-container">
  <div class="entry-video" id="video-player">
    <?php
    $servers = json_decode(get_post_meta(get_the_ID(), 'video_servers', true), true);
    if (!empty($servers)) :
      $first = $servers[0];
      $first_format = $first['format'] ?? '';
      $first_url    = $first['url'] ?? '';

      if ($first_format === 'embed') :
    ?>
        <div class="embed-frame">
          <iframe src="<?= esc_url($first_url) ?>" frameborder="0" allowfullscreen loading="lazy"></iframe>
        </div>
      <?php else : ?>
        <div id="easy3xplay"></div>
        <script>
          document.addEventListener("DOMContentLoaded", function() {
            if (typeof jwplayer !== 'undefined') {
              jwplayer("easy3xplay").setup({
                file: "<?= esc_url($first_url) ?>",
                image: "<?= esc_url(get_the_post_thumbnail_url(get_the_ID(), 'thumb-16x9')) ?>",
                title: "<?= esc_attr(get_the_title()) ?>",
                description: "<?= esc_attr(wp_strip_all_tags(get_the_excerpt(), true)) ?>",
                width: "100%",
                aspectratio: "16:9",
                autostart: false,
                mute: false,
                controls: true,
                preload: "metadata",
                playbackRateControls: true,
                stretching: "uniform",
                repeat: false,
                abouttext: "<?= get_bloginfo('name') ?>",
                aboutlink: "<?= home_url() ?>",
                logo: {
                  file: "<?= esc_url(get_theme_mod('header_logo')) ?>",
                  link: "<?= home_url() ?>",
                  position: "top-right"
                },
                advertising: {
                  client: "vast", // hoặc "googima" nếu dùng Google IMA
                  schedule: [{
                      offset: "pre", // phát trước video (pre-roll)
                      tag: "<?php echo esc_url($vast_url); ?>" // Link VAST Ad
                    },
                    {
                      offset: "50%", // phát giữa video (mid-roll)
                      tag: "<?php echo esc_url($vast_url); ?>"
                    },
                    {
                      offset: "post", // phát sau video (post-roll)
                      tag: "<?php echo esc_url($vast_url); ?>"
                    }
                  ],
                  skipoffset: 5, // cho phép bỏ qua QC sau 5s
                  skipmessage: "Bỏ qua sau %time giây",
                  skiptext: "Bỏ qua quảng cáo"
                }
              });
            }
          });
        </script>
      <?php endif; ?>
    <?php endif; ?>
  </div>

  <header class="entry-header">
    <h1 class="entry-title"><?php the_title(); ?></h1>
  </header>

  <div class="entry-meta" aria-label="Thông tin videos">
    <?php
    // Thời gian chuẩn: x phút trước, x ngày trước, fallback dd/mm/yyyy
    $time_diff = human_time_diff(get_the_time('U'), current_time('timestamp'));
    $time_text = $time_diff ? $time_diff . ' ago' : get_the_date('d/m/Y');

    // Tên tác giả
    $author_name = get_the_author();

    // Label từ metabox
    $video_label = get_post_meta(get_the_ID(), 'video_label', true);
    ?>

    <?php $views = (int) get_post_meta(get_the_ID(), 'video_view', true);
    echo '<span class="video-views">' . number_format_i18n($views) . ' views</span>'; ?>

    <span class="post-date">
      <i class="icon-clock" aria-hidden="true"></i>
      <time datetime="<?= get_the_date(DATE_W3C); ?>"><?= esc_html($time_text); ?></time>
    </span>

    <span class="post-author">
      <i class="icon-user" aria-hidden="true"></i>
      <?= esc_html($author_name); ?>
    </span>

    <?php if ($video_label) : ?>
      <span class="post-label">
        <i class="icon-tag" aria-hidden="true"></i>
        <?= esc_html($video_label); ?>
      </span>
    <?php endif; ?>

  </div>

  <div class="video-action-wrapper">
    <div class="video-action-scroll">
      <div class="video-action-bar" data-postid="<?php the_ID(); ?>">
        <button class="action-btn like" data-action="like">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-thumbs-up">
            <path d="M14 9V5a3 3 0 0 0-3-3l-4 9v11h11.28a2 2 0 0 0 2-1.7l1.38-9a2 2 0 0 0-2-2.3zM7 22H4a2 2 0 0 1-2-2v-7a2 2 0 0 1 2-2h3"></path>
          </svg>
          <span class="count"><?php echo get_post_meta(get_the_ID(), 'video_like', true) ?: 0; ?></span>
        </button>
        <button class="action-btn dislike" data-action="dislike">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-thumbs-down">
            <path d="M10 15v4a3 3 0 0 0 3 3l4-9V2H5.72a2 2 0 0 0-2 1.7l-1.38 9a2 2 0 0 0 2 2.3zm7-13h2.67A2.31 2.31 0 0 1 22 4v7a2.31 2.31 0 0 1-2.33 2H17"></path>
          </svg>
          <span class="count"><?php echo get_post_meta(get_the_ID(), 'video_dislike', true) ?: 0; ?></span>
        </button>
        <button class="action-btn heart" data-action="heart">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-heart">
            <path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"></path>
          </svg>
          <span class="count"><?php echo get_post_meta(get_the_ID(), 'video_heart', true) ?: 0; ?></span>
        </button>
        
      </div>
      
      <button class="action-btn share" id="shareBtn">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-share-2">
          <circle cx="18" cy="5" r="3"></circle>
          <circle cx="6" cy="12" r="3"></circle>
          <circle cx="18" cy="19" r="3"></circle>
          <line x1="8.59" y1="13.51" x2="15.42" y2="17.49"></line>
          <line x1="15.41" y1="6.51" x2="8.59" y2="10.49"></line>
        </svg>
        <span class="count">Share</span>
      </button>
      
      <button class="action-btn report" id="reportBtn">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-circle">
          <circle cx="12" cy="12" r="10"></circle>
          <line x1="12" y1="8" x2="12" y2="12"></line>
          <line x1="12" y1="16" x2="12.01" y2="16"></line>
        </svg>
        <span class="count">Report</span>
      </button>

      <?php if (!empty($servers)) : ?>
        <div class="server-buttons" id="server-buttons">
          <?php foreach ($servers as $index => $s) :
            $name = esc_html($s['name'] ?? 'Server ' . ($index + 1));
            $url  = esc_url($s['url'] ?? '');
            $fmt  = esc_attr($s['format'] ?? ''); ?>
            <button
              type="button"
              class="server-btn"
              data-url="<?= $url ?>"
              data-format="<?= $fmt ?>">
              <?= $name ?>
            </button>
          <?php endforeach; ?>
        </div>

        <script>
          document.querySelectorAll('.server-btn').forEach(btn => {
            btn.addEventListener('click', function() {
              const url = this.dataset.url;
              const format = this.dataset.format;
              const container = document.getElementById('video-player');

              if (format === 'embed') {
                container.innerHTML = `
              <div class="embed-frame">
                <iframe src="${url}" frameborder="0" allowfullscreen loading="lazy"></iframe>
              </div>`;
              } else {
                container.innerHTML = `<div id="easy3xplay"></div>`;
                if (typeof jwplayer !== 'undefined') {
                  jwplayer("easy3xplay").setup({
                    file: url,
                    image: "<?= esc_url(get_the_post_thumbnail_url(get_the_ID(), 'thumb-16x9')) ?>",
                    title: "<?= esc_attr(get_the_title()) ?>",
                    description: "<?= esc_attr(wp_strip_all_tags(get_the_excerpt(), true)) ?>",
                    width: "100%",
                    aspectratio: "16:9",
                    autostart: false,
                    mute: false,
                    controls: true,
                    preload: "metadata",
                    playbackRateControls: true,
                    stretching: "uniform",
                    repeat: false,
                    abouttext: "<?= get_bloginfo('name') ?>",
                    aboutlink: "<?= home_url() ?>",
                    logo: {
                      file: "<?= esc_url(get_theme_mod('header_logo')) ?>",
                      link: "<?= home_url() ?>",
                      position: "top-right"
                    },
                    advertising: {
                      client: "vast",
                      schedule: {}
                    }
                  });
                }
              }
            });
          });
        </script>
      <?php endif; ?>

      
    </div>

    <div class="video-action-fade left"></div>
    <div class="video-action-fade right"></div>
  </div>



</section>