<section class="section-related-videos sections" aria-label="Video liên quan">
  <h2 class="section-title">
    Related Videos
    <span class="icon-wrap" aria-hidden="true">
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg">
        <polygon points="23 7 16 12 23 17 23 7"></polygon>
        <rect x="1" y="5" width="15" height="14" rx="2" ry="2"></rect>
      </svg>
    </span>
  </h2>

  <ul class="video-list">
    <?php
    $post_id    = get_the_ID();
    $post_type  = get_post_type($post_id);

    // Tách tiêu đề thành các từ dài > 3 ký tự, bỏ trùng, lowercase
    $title_words = array_unique(array_filter(array_map('strtolower', explode(' ', wp_strip_all_tags(get_the_title()))), function ($w) {
      return strlen($w) > 3;
    }));

    // Category và tag của bài hiện tại
    $categories = wp_get_post_categories($post_id);
    $tags       = wp_get_post_tags($post_id, ['fields' => 'ids']);

    $related = null;

    // Bước 1: Tìm bài có ít nhất 3 từ trùng + cùng category/tag (toàn site)
    if (count($title_words) >= 3) {
      $related = new WP_Query([
        'post_type'           => $post_type,
        'posts_per_page'      => 12,
        'post__not_in'        => [$post_id],
        'ignore_sticky_posts' => true,
        'orderby'             => 'date',
        'order'               => 'DESC',
        's'                   => implode(' ', array_slice($title_words, 0, 6)),
        'tax_query'           => [
          'relation' => 'OR',
          [
            'taxonomy' => 'category',
            'field'    => 'term_id',
            'terms'    => $categories,
          ],
          [
            'taxonomy' => 'post_tag',
            'field'    => 'term_id',
            'terms'    => $tags,
          ],
        ],
      ]);
    }

    // Bước 2: Nếu không tìm thấy, fallback random trong category/tag
    if (!$related || !$related->have_posts()) {
      $related = new WP_Query([
        'post_type'           => $post_type,
        'posts_per_page'      => 12,
        'post__not_in'        => [$post_id],
        'ignore_sticky_posts' => true,
        'orderby'             => 'rand',
        'tax_query'           => [
          'relation' => 'OR',
          [
            'taxonomy' => 'category',
            'field'    => 'term_id',
            'terms'    => $categories,
          ],
          [
            'taxonomy' => 'post_tag',
            'field'    => 'term_id',
            'terms'    => $tags,
          ],
        ],
      ]);
    }

    // Bước 3: Nếu vẫn không có, lấy bài mới nhất toàn site
    if (!$related->have_posts()) {
      $related = new WP_Query([
        'post_type'           => $post_type,
        'posts_per_page'      => 12,
        'post__not_in'        => [$post_id],
        'ignore_sticky_posts' => true,
        'orderby'             => 'date',
        'order'               => 'DESC',
      ]);
    }

    // Hiển thị danh sách
    if ($related->have_posts()) :
      while ($related->have_posts()) : $related->the_post();
        $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
        $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
    ?>
        <li class="video-item">
          <article class="video-post">
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="video-link">
              <div class="video-thumb">
                <?php echo easy3x_lazy_thumb(get_the_ID()); ?>
                <?php if ($video_label) : ?>
                  <span class="video-label"><?php echo esc_html($video_label); ?></span>
                <?php endif; ?>
                <?php if ($video_duration) : ?>
                  <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                <?php endif; ?>
              </div>
              <h3 class="video-title"><?php the_title(); ?></h3>
            </a>
          </article>
        </li>
    <?php endwhile;
      wp_reset_postdata();
    endif; ?>
  </ul>
</section>