<section class="section-related-videos" aria-label="Video liên quan">
  <h2 class="section-title">
    Related videos
    <span class="icon-wrap" aria-hidden="true">
      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon-svg"><polygon points="23 7 16 12 23 17 23 7"></polygon><rect x="1" y="5" width="15" height="14" rx="2" ry="2"></rect></svg>
    </span>
  </h2>

  <ul class="video-list">
    <?php
    $post_id = get_the_ID();
    $related_args = [
      'post_type'           => 'post', // hoặc 'video' nếu là CPT
      'posts_per_page'      => 10,
      'post__not_in'        => [$post_id],
      'ignore_sticky_posts' => true,
      'orderby'             => 'rand', // fallback nếu không có tags/category

      'tax_query' => [
        'relation' => 'OR',
        [
          'taxonomy' => 'category',
          'field'    => 'term_id',
          'terms'    => wp_get_post_categories($post_id),
        ],
        [
          'taxonomy' => 'post_tag',
          'field'    => 'term_id',
          'terms'    => wp_get_post_tags($post_id, ['fields' => 'ids']),
        ],
      ],
    ];

    $related = new WP_Query($related_args);

    if ($related->have_posts()) :
      while ($related->have_posts()) : $related->the_post();

        $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
        $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
        $title_attr     = esc_attr(get_the_title());
        $permalink      = esc_url(get_permalink());
    ?>
      <li class="video-item">
        <article class="video-post">
          <a href="<?= $permalink ?>" title="<?= $title_attr ?>" class="video-link">
            <div class="video-thumb">
              <?= easy3x_lazy_thumb(get_the_ID()) ?>
              <?php if ($video_label) : ?>
                <span class="video-label"><?= esc_html($video_label) ?></span>
              <?php endif; ?>
              <?php if ($video_duration) : ?>
                <span class="video-duration"><?= esc_html($video_duration) ?></span>
              <?php endif; ?>
            </div>
            <h3 class="video-title"><?= get_the_title() ?></h3>
          </a>
        </article>
      </li>
    <?php endwhile; wp_reset_postdata(); endif; ?>
  </ul>
</section>
