<?php
$tags = get_terms( array(
  'taxonomy'   => 'search', // taxonomy: post_tag hoặc custom
  'orderby'    => 'count',
  'order'      => 'DESC',
  'number'     => 15,
  'hide_empty' => true,
) );

if ( ! empty( $tags ) && ! is_wp_error( $tags ) ) : ?>
  <section class="popular-tags sections" aria-labelledby="popular-tags-title">
    <h2 id="popular-tags-title" class="section-title">
      <?php esc_html_e( 'Thẻ Phổ Biến', 'your-textdomain' ); ?>
    </h2>

    <ul class="tag-list">
      <?php foreach ( $tags as $tag ) : ?>
        <li class="tag-item">
          <a href="<?php echo esc_url( get_term_link( $tag ) ); ?>"
             class="tag-link"
             title="<?php echo esc_attr( sprintf( __( 'Xem tất cả bài viết có thẻ %s', 'your-textdomain' ), $tag->name ) ); ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                 fill="none" stroke="currentColor" stroke-width="2"
                 stroke-linecap="round" stroke-linejoin="round"
                 class="tag-icon" aria-hidden="true">
              <path d="M20.59 13.41l-7.17 7.17a2 2 0 0 1-2.83 0L2 12V2h10l8.59 8.59a2 2 0 0 1 0 2.82z"/>
              <line x1="7" y1="7" x2="7.01" y2="7"/>
            </svg>
            <span class="tag-name"><?php echo esc_html( $tag->name ); ?></span>
            <span class="tag-count"><?php echo intval( $tag->count ); ?></span>
          </a>
        </li>
      <?php endforeach; ?>
    </ul>
  </section>
<?php endif; ?>
