<section class="popular-tags sections">
  <h2 class="section-title">Popular Tags</h2>
  <ul class="tag-list">
    <?php
    $tags = get_tags([
      'orderby'    => 'count',
      'order'      => 'DESC',
      'number'     => 5,
      'hide_empty' => true,
    ]);

    foreach ($tags as $tag):
      $tag_link = get_tag_link($tag->term_id);
    ?>
      <li class="tag-item">
        <a href="<?php echo esc_url($tag_link); ?>" class="tag-link" title="<?php echo esc_attr($tag->name); ?>">
          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="tag-icon"><path d="M20.59 13.41l-7.17 7.17a2 2 0 0 1-2.83 0L2 12V2h10l8.59 8.59a2 2 0 0 1 0 2.82z"></path><line x1="7" y1="7" x2="7.01" y2="7"></line></svg>
          <span class="tag-name"><?php echo esc_html($tag->name); ?></span>
          <span class="tag-count">(<?php echo intval($tag->count); ?>)</span>
        </a>
      </li>
    <?php endforeach; ?>
  </ul>
</section>