<section class="top-videos sections">
  <h2 class="section-title">Most Viewed</h2>
  <div class="section-des"></div>
  <div class="tabbed-posts">
    <ul class="tab-buttons">
      <li><button class="tab-btn active" data-tab="day">Day</button></li>
      <li><button class="tab-btn" data-tab="week">Week</button></li>
      <li><button class="tab-btn" data-tab="month">Month</button></li>
    </ul>

    <div class="tab-contents">
      <?php
      $tabs = [
        'day'   => strtotime('-1 day'),
        'week'  => strtotime('-7 days'),
        'month' => strtotime('-30 days'),
      ];

      foreach ($tabs as $key => $after_time) :
        $query = new WP_Query([
          'post_type'           => 'post', // hoặc 'video'
          'posts_per_page'      => 10,
          'meta_key'            => 'video_view',
          'orderby'             => 'meta_value_num',
          'order'               => 'DESC',
          'date_query'          => [
            [
              'after'     => date('Y-m-d H:i:s', $after_time),
              'inclusive' => true,
            ]
          ],
          'ignore_sticky_posts' => true,
        ]);
      ?>
        <div class="tab-panel<?php echo $key === 'day' ? ' active' : ''; ?>" data-tab="<?php echo esc_attr($key); ?>">
          <ul class="video-list">
            <?php
            if ($query->have_posts()) :
              while ($query->have_posts()) : $query->the_post();
                $video_label    = get_post_meta(get_the_ID(), 'video_label', true);
                $video_duration = get_post_meta(get_the_ID(), 'video_duration', true);
            ?>
                <li class="video-item">
                  <article class="video-post">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="video-link">
                      <div class="video-thumb">
                        <?php echo function_exists('easy3x_lazy_thumb') ? easy3x_lazy_thumb(get_the_ID()) : get_the_post_thumbnail(get_the_ID(), 'medium'); ?>
                        <?php if ($video_label) : ?>
                          <span class="video-label"><?php echo esc_html($video_label); ?></span>
                        <?php endif; ?>
                        <?php if ($video_duration) : ?>
                          <span class="video-duration"><?php echo esc_html($video_duration); ?></span>
                        <?php endif; ?>
                      </div>
                      <h3 class="video-title"><?php the_title(); ?></h3>
                    </a>
                  </article>
                </li>
              <?php endwhile;
              wp_reset_postdata(); ?>
            <?php else : ?>
              <li class="no-posts"><?php _e('Không có video nào :(', 'textdomain'); ?></li>
            <?php endif; ?>
          </ul>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>


<script>
  document.addEventListener('DOMContentLoaded', function() {
    const buttons = document.querySelectorAll('.tab-btn');
    const panels = document.querySelectorAll('.tab-panel');

    buttons.forEach(btn => {
      btn.addEventListener('click', function() {
        buttons.forEach(b => b.classList.remove('active'));
        panels.forEach(p => p.classList.remove('active'));

        this.classList.add('active');
        const tab = this.getAttribute('data-tab');
        document.querySelector(`.tab-panel[data-tab="${tab}"]`).classList.add('active');
      });
    });
  });
</script>